/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.embed;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visualization.VisualEmbedding;
import com.zurrtum.create.client.flywheel.backend.compile.ContextShader;
import com.zurrtum.create.client.flywheel.backend.engine.EngineImpl;
import com.zurrtum.create.client.flywheel.backend.engine.embed.Environment;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.lib.util.ExtraMemoryOps;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2382;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@net.fabricmc.api.Environment(value=EnvType.CLIENT)
public class EmbeddedEnvironment
implements VisualEmbedding,
Environment {
    private final EngineImpl engine;
    private final class_2382 renderOrigin;
    @Nullable
    private final EmbeddedEnvironment parent;
    private final InstancerProvider instancerProvider;
    private final Matrix4f pose = new Matrix4f();
    private final Matrix3f normal = new Matrix3f();
    private final Matrix4f poseComposed = new Matrix4f();
    private final Matrix3f normalComposed = new Matrix3f();
    public int matrixIndex = 0;
    private boolean deleted = false;

    public EmbeddedEnvironment(final EngineImpl engine, class_2382 renderOrigin, @Nullable EmbeddedEnvironment parent) {
        this.engine = engine;
        this.renderOrigin = renderOrigin;
        this.parent = parent;
        this.instancerProvider = new InstancerProvider(){

            @Override
            public <I extends Instance> Instancer<I> instancer(InstanceType<I> type, Model model, int bias) {
                return engine.instancer(EmbeddedEnvironment.this, type, model, bias);
            }
        };
    }

    public EmbeddedEnvironment(EngineImpl engine, class_2382 renderOrigin) {
        this(engine, renderOrigin, null);
    }

    @Override
    public void transforms(Matrix4fc pose, Matrix3fc normal) {
        this.pose.set(pose);
        this.normal.set(normal);
    }

    @Override
    public InstancerProvider instancerProvider() {
        return this.instancerProvider;
    }

    @Override
    public class_2382 renderOrigin() {
        return this.renderOrigin;
    }

    @Override
    public VisualEmbedding createEmbedding(class_2382 renderOrigin) {
        EmbeddedEnvironment out = new EmbeddedEnvironment(this.engine, renderOrigin, this);
        this.engine.environmentStorage().track(out);
        return out;
    }

    @Override
    public ContextShader contextShader() {
        return ContextShader.EMBEDDED;
    }

    @Override
    public void setupDraw(GlProgram program) {
        program.setMat4("_flw_modelMatrixUniform", (Matrix4fc)this.poseComposed);
        program.setMat3("_flw_normalMatrixUniform", (Matrix3fc)this.normalComposed);
    }

    @Override
    public int matrixIndex() {
        return this.matrixIndex;
    }

    public void flush(long ptr) {
        this.poseComposed.identity();
        this.normalComposed.identity();
        this.composeMatrices(this.poseComposed, this.normalComposed);
        ExtraMemoryOps.putMatrix4f(ptr, (Matrix4fc)this.poseComposed);
        ExtraMemoryOps.putMatrix3fPadded(ptr + 64L, (Matrix3fc)this.normalComposed);
    }

    private void composeMatrices(Matrix4f pose, Matrix3f normal) {
        if (this.parent != null) {
            this.parent.composeMatrices(pose, normal);
            pose.mul((Matrix4fc)this.pose);
            normal.mul((Matrix3fc)this.normal);
        } else {
            pose.set((Matrix4fc)this.pose);
            normal.set((Matrix3fc)this.normal);
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void delete() {
        this.deleted = true;
    }
}

